#!/bin/bash
export datasets="wikics cs"
export missing_rates="0.0 0.1 0.9999 1.0"
# export missing_rates="0.0 1.0"
export lambda_list_1="0.00001"
export lambda_list_2="0.00001 10 0.001 0.01 0.1 1 10"
export lp_alpha_list="0.9 0.99 0.9 0.99"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export gpu=3

for missing_rate in $missing_rates
do
python main.py --dataset cs --missing_rate ${missing_rate} --embedder GOODIE_pseudo --pseudo_type train --lp_alpha 0.99 --lamb 10 --n_runs 10 --missing_type structural --gpu ${gpu}
python main.py --dataset cs --missing_rate ${missing_rate} --embedder GOODIE_pseudo --pseudo_type all_1 --lp_alpha 0.99 --lamb 10 --n_runs 10 --missing_type structural --gpu ${gpu}
python main.py --dataset cs --missing_rate ${missing_rate} --embedder GOODIE_pseudo --pseudo_type all_y --lp_alpha 0.99 --lamb 10 --n_runs 10 --missing_type structural --gpu ${gpu}
python main.py --dataset cs --missing_rate ${missing_rate} --embedder GOODIE_pseudo --pseudo_type strong_1 --lp_alpha 0.99 --lamb 10 --n_runs 10 --missing_type structural --gpu ${gpu}
done

